import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;

public class CommentField extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean CanBeDeletedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeMovedByUser()
	{
		return true;
	};

	@Override
	public boolean CanBeSelectedByUser()
	{
		return true;
	}
	// end of DrawObject abilities

	private Point SizeOriginal;

	public CommentField(Point TopLeftPos, Point Size)
	{
		SetPos(TopLeftPos);
		SetSize(Size);
		InitializeExcitement(ExcitementOnceMilliseconds);

		SizeOriginal = this.Size; // DO NOT set SizeOriginal in Size() method! The system calls SetSize() to "hide" CommentField, by setting its size to 0, 0
	};

	@Override
	public void Draw(Graphics g)
	{
		// doesn't draw anything, only used for generating (spawning) child objects
	}

	public ArrayList<DrawObject> GenerateChildObjects()
	{
		ArrayList<DrawObject> ChildObjects = new ArrayList<DrawObject>();

		SetSize(SizeOriginal); // restore the size from class constructor

		ChildObjects.add(new Node(new Point(Pos.x, Pos.y)));
		ChildObjects.add(new Node(new Point(Pos.x + Size.x, Pos.y)));
		ChildObjects.add(new Node(new Point(Pos.x + Size.x, Pos.y + Size.y)));
		ChildObjects.add(new Node(new Point(Pos.x, Pos.y + Size.y)));

		ChildObjects.add(new Line(ChildObjects.get(0), ChildObjects.get(1)));
		ChildObjects.add(new Line(ChildObjects.get(1), ChildObjects.get(2)));
		ChildObjects.add(new Line(ChildObjects.get(2), ChildObjects.get(3)));
		ChildObjects.add(new Line(ChildObjects.get(3), ChildObjects.get(0)));

		ChildObjects.add(new TextField(new Point(Pos.x, Pos.y)));

		for (int m = 0; m < ChildObjects.size(); m++)
			ChildObjects.get(m).SetIsCommentField(true);

		SetSize(new Point(0, 0)); // necessary, or CommentField hides all DrawObject within its frame bounds (not desired)

		return ChildObjects;
	}
}
